#!/bin/sh

source /etc/utils/shell-utils.sh

upload_sboot=/ram/SbootIm
head_sboot=/ram/SbootHead
one_sboot=/ram/one_sboot.img
cmp_sboot=/ram/cmp_sboot.img

update_mag522() {

    bl2_sboot=/ram/bl2_sboot.img
    bl3_sboot=/ram/bl3_sboot.img
    bl2_cmp=/ram/bl2_cmp.img
    bl3_cmp=/ram/bl3_cmp.img
    buf_mtd0=/ram/mtd0.img
    buf_mtd1=/ram/mtd1.img

    dd if=$one_sboot of=$bl2_sboot bs=64K count=1 2>/dev/null
    dd if=$one_sboot of=$bl3_sboot bs=64K skip=1 2>/dev/null

    flag=0
    nanddump /dev/mtd0 > $buf_mtd0 2>/dev/null
    for i in 3 2 1 0 ; do
        rm -f $bl2_cmp
        dd if=$buf_mtd0 of=$bl2_cmp bs=64K skip=$((0x100000*$i/0x10000)) count=1 conv=notrunc 2>/dev/null
        cmp -s $bl2_cmp $bl2_sboot
        if [ "$?" -ne "0" ]; then
            flag=1
        fi
    done
    if [ "$flag" == "1" ]; then
        echo "====== Flash bl2 ======"
        for i in 3 2 1 0 ; do
            flash_erase -q -N /dev/mtd0 $((0x100000*$i)) 1
            nandwrite -p -s $((0x100000*$i)) /dev/mtd0 $bl2_sboot 2>&1 >/dev/null
        done
    fi

    flag=0
    nanddump --bb=skipbad /dev/mtd1 > $buf_mtd1 2>/dev/null
    for i in 3 2 1 0 ; do
        rm -f $bl3_cmp
        dd if=$buf_mtd1 of=$bl3_cmp bs=64K skip=$((0x200000*$i/0x10000)) count=$(($1/0x10000)) conv=notrunc 2>/dev/null
        dd if=/dev/null of=$bl3_cmp bs=1 count=0 seek=$(($1-0x10000)) 2>/dev/null
        cmp -s $bl3_cmp $bl3_sboot
        if [ "$?" -ne "0" ]; then
            flag=1
        fi
    done
    if [ "$flag" == "1" ]; then
        echo "====== Flash bl3x ======"
        for i in 3 2 1 0 ; do
            flash_erase -q /dev/mtd1 $((0x200000*$i)) $((($1+0x3ffff)/0x40000))
            nandwrite -p -s $((0x200000*$i)) /dev/mtd1 $bl3_sboot 2>&1 >/dev/null
        done
    fi

    rm -f $bl2_cmp $bl3_cmp $bl2_sboot $bl3_sboot $buf_mtd0 $buf_mtd0
}


if [ "$1" != "" ]; then
    upload_sboot=$1
fi

if [ ! -e $upload_sboot ]; then
    echo "ERROR: File $upload_sboot not present!!!"
    exit 1
fi

get_file_size "$upload_sboot" size

if [ $size -eq 0 ]; then
    echo "ERROR: Uploading bootloader is failed."
    exit 1;
fi

rm -f $head_sboot
dd if=$upload_sboot of=$head_sboot bs=1K count=1 2>/dev/null
offset=`awk '{if($0 == "Start data..."){s+=length($0)+1;print s;exit;}else{s+=length($0)+1;}}' $head_sboot` 2>/dev/null
dd if=/dev/null of=$head_sboot bs=1 count=0 seek=$offset 2>/dev/null

get_model_ext model_ext
get_hwver hwver
if [ "$model_ext" == "MAG520" ] || [ "$model_ext" == "MAG524" ] || \
   [ "$model_ext" == "MAG522v2" ]; then
    if [ "${hwver:4:3}" == "P0L" ]; then
        type="MAG520"
    fi
fi

if [ "$model_ext" == "MAG522" ] ; then
    if [ "${hwver:4:3}" == "P0L" ]; then
        type="MAG522"
    fi
fi

# Find need bootloader in the package
tmp=`grep -w "$type" $head_sboot` 2>/dev/null
size=`echo "$tmp" | awk '{print $2}'`
pos=`echo "$tmp" | awk '{print $3}'`
echo "======[$type] [$size] [$pos] [$offset]======"
if [ "$pos" == "" ] || [ "$size" == "" ]; then
    rm -f $upload_sboot $head_sboot $one_sboot $cmp_sboot
    echo "OK"
    exit 0
fi

# Compare bootloader hash
dd if=$upload_sboot of=$one_sboot skip=$(($pos+$offset)) bs=1 count=$size 2>/dev/null
value1=`dd if=$one_sboot count=1 bs=$(($size-32)) | sha256sum | cut -d' ' -f1` 2>/dev/null
value2=`hexdump -e '32/1 "%02x"' -s $(($size-32)) -n 32 $one_sboot`
if [ "$value1" != "$value2" ]; then
    echo "ERROR: Hash sum mismatch!!!"
    exit 1
fi

# Check magic number
value1=`hexdump -e '4/1 "%02x"' -s $(($size-36)) -n 4 $one_sboot`
if [ "$value1" != "1e5b1fb1" ]; then
    echo "ERROR: Magic number mismatch!!!"
    exit 1
fi

# Check alowable bootloder epoch
get_name_and_len_part "bootloader" max vend_sect
value1=`hexdump -e '1/ "%d"' -s $(($max-256)) -n 4 /dev/$vend_sect`
value2=`hexdump -e '1/ "%d"' -s $(($size-44)) -n 4 $one_sboot`
if [ "$value1" -gt "$value2" ]; then
    rm -f $upload_sboot $head_sboot $one_sboot $cmp_sboot
    echo "OK"
    exit 0
fi

# Bootloader length without footer
value1=`hexdump -e '1/ "%d"' -s $(($size-40)) -n 4 $one_sboot`
if [ "$value1" -gt "0" ] && [ "$value1" -le "1024" ]; then
   size=$(($size-value1-40))
   dd if=/dev/null of=$one_sboot bs=1 count=0 seek=$size 2>/dev/null
fi


get_flash_type flash_type
if [ $flash_type == "nand" ]; then

    if [ "$size" -gt "2097152" ]; then
        echo "ERROR: Sboot file too large!!!"
        exit 1
    fi

    if [ "$type" == "MAG522" ] ; then
        echo "======Sboot is flashed NAND with length [$size]======"
        update_mag522 $size
    fi

elif [ $flash_type == "mmc" ]; then

    if [ "$size" -gt "4000000" ]; then
        echo "ERROR: Sboot file too large!!!"
        exit 1
    fi

    get_name_and_len_part "bootloader" max name_part
    dd if=/dev/$name_part of=$cmp_sboot bs=1 seek=512 count=$size 2>/dev/null

    cmp -s $cmp_sboot $one_sboot
    if [ "$?" -ne "0" ]; then
        echo "======Sboot is flashed EMMC with length [$size]======"
        dd if=$one_sboot of=/dev/$name_part bs=512 seek=1 2>/dev/null
        if [ "$?" -ne "0" ]; then
            echo "ERROR: Write to EMMC flash failed!!!"
            exit 1
        fi
    fi
fi

rm -f $upload_sboot $head_sboot $one_sboot $cmp_sboot
echo "OK"
exit 0
