'use strict';


function CRcPairingModal ( page ) {
    var self = this;

    CModalBox.call(this, page);

    this.countdown = element('div', {className: 'cmodal-countdown'});

    this.EventHandler = function ( event ) {
        self.bpanel.EventHandler(event);
    };
}

CRcPairingModal.prototype = Object.create(CModalBox.prototype);
CRcPairingModal.prototype.constructor = CRcPairingModal;

CRcPairingModal.prototype.SetCountdown  = function ( data ) { return this.SetData(this.countdown, data || ''); };

CRcPairingModal.prototype.Init = function () {
    CModal.prototype.Init.call(this,
        element('div', {className:'cmodal-body'}, [
            this.countdown,
            this.header,
            this.content,
            this.footer
        ]
    ));
};


function createConfirmModal() {
    var confirmModal = new CModalBox();

    confirmModal.baseClass += ' confirm-modal';
    confirmModal.bpanel = new CButtonPanel();
    confirmModal.bpanel.Init(configuration.newRemoteControl ? PATH_IMG_SYSTEM + 'buttons/new/' : PATH_IMG_SYSTEM + 'buttons/old/');
    confirmModal.bpanel.btnExit = confirmModal.bpanel.Add(
        KEYS.EXIT,
        'exit.png',
        _('Cancel'),
        function () {
            stbWebWindow.close();
        }
    );
    confirmModal.bpanel.btnOk = confirmModal.bpanel.Add(
        KEYS.OK,
        'ok.png',
        _('Disable'),
        function () {
            var configFile = 'remoteControl.json',
                netrcConfig = {enable: false, deviceName: '', password: ''};

            try {
                netrcConfig = JSON.parse(gSTB.LoadUserData(configFile));
            } catch ( error ) {
            }

            netrcConfig.enable = false;
            gSTB.SetNetRcStatus(false);
            gSTB.SaveUserData('remoteControl.json', JSON.stringify(netrcConfig));

            mobileRcManager.enabled = false;
            stbWebWindow.close();
        }
    );

    confirmModal.SetHeader(_('Do you want to disable remote control?'));
    confirmModal.SetContent([
        element('div', {}, _('To re-enable, please refer to settings:')),
        element('div', {}, _('(Settings > System Settings > Remote Control).')),
    ]);

    confirmModal.SetFooter(confirmModal.bpanel.handle);
    confirmModal.EventHandler = function ( event ) {
        confirmModal.bpanel.EventHandler(event);
    };
    confirmModal.Init();

    return confirmModal;
}


function initPage () {
    console.log(configuration);
    var modal = new CRcPairingModal(),
        confirmModal = createConfirmModal(),
        timeLeft = mobileRcManager.dialogDisplayTimeoutSeconds,
        $timerValue = element('span', {}, timeLeft + ' '),
        countDownTimer;


    modal.baseClass += ' rc-pairing';
    modal.bpanel = new CButtonPanel();
    modal.bpanel.Init(configuration.newRemoteControl ? PATH_IMG_SYSTEM + 'buttons/new/' : PATH_IMG_SYSTEM + 'buttons/old/');
    modal.bpanel.btnExit = modal.bpanel.Add(
        KEYS.EXIT,
        'exit.png',
        _('Refuse and disable remote control'),
        function () {
            countDownTimer && clearInterval(countDownTimer);

            modal.Show(false);
            confirmModal.Show(true, true);
        }
    );
    modal.bpanel.btnOk = modal.bpanel.Add(
        KEYS.OK,
        'ok.png',
        _('Close'),
        function () {
            mobileRcManager.refuseConnect();
            stbWebWindow.close();
        }
    );

    modal.SetCountdown(element('div', {}, [
        $timerValue,
        element('span', {}, _('sec...'))
    ]));

    modal.SetHeader(_('Device pairing request'));
    modal.SetContent([
        element('div', {className: 'rc-pairing__subtitle'}, _('Enter the following code on your Remote control Application to control this device')),
        element('div', {className: 'rc-pairing__code'}, mobileRcManager.getPairingCode()),
        element('div', {className: 'rc-pairing__attention'}, _('* Attention, upon successful connection, you enable Active Standby mode on your set-top box, this is necessary for the correct operation of the on and off function, you can disable the mode in the set-top box settings.'))
    ]);

    countDownTimer = setInterval(function () {
        timeLeft--;
        $timerValue.innerText = timeLeft + ' ';
        if ( timeLeft <= 0 ) {
            stbWebWindow.close();

            clearInterval(countDownTimer);
        }
    }, 1000);

    document.addEventListener('keydown', function ( event ) {
        if ( !eventPrepare(event, true) ) {
            return;
        }

        if  ( event.code === KEYS.POWER ) {
            return stbWebWindow.messageSend(getWindowIdByName(WINDOWS.PORTAL), 'portal.standbyMode', '');
        }

        if ( modal.isVisible ) {
            return modal.EventHandler(event);
        }

        if ( confirmModal.isVisible ) {
            confirmModal.EventHandler(event);
        }
    });

    modal.SetFooter(modal.bpanel.handle);
    modal.Init();
    modal.Show(true, true);
}

window.onload = function () {
    var environment = JSON.parse(gSTB.GetEnv(JSON.stringify({varList: ['language']}))).result,
        language = environment.language;

    gettext.init({name: language, path: 'lang'}, initPage);
};
