#!/bin/sh

. /etc/utils/shell-utils.sh
DEBUG=0

WIFI_CURR_DRIVER_FILE=/ram/wifi/curr_driver
UNISOC_SDIO_BUS="/sys/bus/mmc/devices/sdio:8800/sdio:8800:1"
REALTEK_SDIO_BUS="/sys/bus/mmc/devices/sdio:0001/sdio:0001:1"

wifi_driver=$(cat "$WIFI_CURR_DRIVER_FILE" 2>/dev/null)

log "wifi_driver=$wifi_driver"
if [ -n "$wifi_driver" ]; then
    log "[i] External WIFI dongle active. Deiniting..."
    /etc/init.d/wifi_if_handler.sh stop
    exit 0
fi

log "Deinitializing embedded WIFI module."
/etc/init.d/wifi_stop_wa.sh

wpa_cli disconnect
wpa_cli flush
wpa_cli terminate
sleep 0.5
log "WPAsuplicant killed ."
ifconfig wlan0 down

deinit_internal_88xxcs()
{
    vendor=$(cat "$REALTEK_SDIO_BUS/vendor" 2>/dev/null)
    device=$(cat "$REALTEK_SDIO_BUS/device" 2>/dev/null)
    if  [ "$vendor" = "0x024c" ]; then
        log "[i] 882xcs module will be removed right now."

        case "$device" in
            0xc822)
                    rmmod 8822cs
                ;;
            0xc821)
                    rmmod 8821cs
                ;;
        esac
    fi
}

deinit_internal_unisoc()
{
    if [ -d ${UNISOC_SDIO_BUS} ] ; then
        rmmod sprdwl_ng
        #do not remove uwe5621_bsp_sdio since it can lead to crash during deep standby
        #rmmod uwe5621_bsp_sdio
    fi
}

case "$(lsusb)" in
  *0bda:d723*)
        log "Deinitializing [RTL8723DU]."
        rmmod 8723du
        ;;
  *0bda:b82c*)
        log "Deinitializing [RTL8822BU]."
        rmmod 8822bu
        ;;
  *)
      deinit_internal_88xxcs
      deinit_internal_unisoc
      ;;
esac


exit 0
