#!/bin/sh

selectGraphRes() {
    case $gres in
        720)
            g_width=720
            g_height=576
        ;;
        1280)
            g_width=1280
            g_height=720
        ;;
        1920)
            g_width=1920
            g_height=1080
        ;;
        tvsystem_res)
            echo "selected graphics as video"
            case $tvmode in
                pal|PAL|576p-50)
                    g_width=720
                    g_height=576
                ;;
                ntsc|NTSC)
                    g_width=720
                    g_height=480
                ;;
                720p-50|720p-60)
                    g_width=1280
                    g_height=720
                ;;
                1080i-50|1080i-60|1080p-50|1080p-60|3840x2160p50|3840x2160p60)
                    g_width=1920
                    g_height=1080
             ;;
             esac
        ;;
        *)
        ;;
    esac
}
source /etc/utils/shell-utils.sh
source /etc/property_set.sh
BASEDIR=$(dirname "$0")

#set -x

export QT_ROOT=/usr/lib/qt-everywhere-opensource-src-5.8.0
export LD_LIBRARY_PATH=$QT_ROOT/lib:$LD_LIBRARY_PATH:/lib/pulseaudio/
export LD_LIBRARY_PATH=/usr/lib:/usr/local/share/app/lib:$LD_LIBRARY_PATH
export QT_QPA_PLATFORM_PLUGIN_PATH=$QT_ROOT/plugins
export QT_QPA_FONTDIR=$QT_ROOT/lib/fonts
export QML2_IMPORT_PATH=$QT_ROOT/qml
#export QT_LOGGING_CONF=/usr/lib/modules/qtlog.ini
export QT_LIBDIR_EGL=/usr/lib
export QT_LIBDIR_GLES2=/usr/lib
export FONTCONFIG_FILE=$QT_ROOT/lib/fonts/fonts.conf
export FONTCONFIG_PATH=$QT_ROOT/lib/fonts/
export ICU_DATA=$QT_ROOT/resources/icudtl.dat


export QT_QPA_PLATFORM=eglfs
export QT_QPA_EGLFS_FORCE888=1
export QT_QPA_EGLFS_PHYSICAL_WIDTH=96; export QT_QPA_EGLFS_PHYSICAL_HEIGHT=96
#export QT_QPA_EGLFS_WIDTH=1280; export QT_QPA_EGLFS_HEIGHT=720
export QT_QPA_EGLFS_DEBUG=1
export QT_QPA_EGLFS_INTEGRATION=eglfs_mali
export QT_QPA_EGLFS_SWAPINTERVAL=1
#export QT_LOGGING_RULES=qt.qpa.*=true
export QT_QPA_EGLFS_DEPTH=32
export QT_QPA_EGLFS_FORCEVSYNC=0
export QT_QPA_EGLFS_DISABLE_INPUT=1
export DBUS_SYSTEM_BUS_ADDRESS="unix:path=/var/run/dbus/system_bus_socket"
export PULSE_STATE_PATH="/mnt/Userfs/pulse"
export PULSE_RUNTIME_PATH="/var/run/pulse"


# check for certain variables
/usr/local/share/app/bin/STD_check_env.sh

# print start banner
dt=`date`
for i in {1..100};
do
    echo "[${dt}] StbApp is about to start..."
done

#cp ./info.txt /ram/info.txt
/usr/local/share/app/bin/info.sh > /ram/info.txt

# calculate graphic resolution
g_width=1280
g_height=720

get_fw_env "graphicres" gres
get_fw_env "tvsystem" tvmode

if [ -z ${gres} ]; then
    echo "Graphicres is undefined. defaulting to 1280..."
fi

echo "tvmode = ${tvmode}"
echo "graphicres = ${gres}"

case $tvmode in
    ntsc|NTSC)
        g_width=720
        g_height=480
    ;;
    *)
        selectGraphRes
    ;;
esac

echo "Setting graphics resolution to ${g_width}:${g_height}"

PORTAL_TO_LOAD="file:///usr/local/share/app/web/system/pages/loader/index.html"

for X in `cat /proc/cmdline`
do
    if [[ ${X:0:10} == "bootmedia=" ]]; then
        [ "${CMD_LINE}" ] && CMD_LINE="${CMD_LINE}&${X}" || CMD_LINE="${CMD_LINE}${X}"
    elif [[ ${X:0:14} == "fallbackstate=" ]]; then
        [ "${CMD_LINE}" ] && CMD_LINE="${CMD_LINE}&${X}" || CMD_LINE="${CMD_LINE}${X}"
    elif [[ ${X:0:9} == "btnstate=" ]]; then
        [ "${CMD_LINE}" ] && CMD_LINE="${CMD_LINE}&${X}" || CMD_LINE="${CMD_LINE}${X}"
    fi
done
[ "${CMD_LINE}" ] && PORTAL_TO_LOAD="${PORTAL_TO_LOAD}?${CMD_LINE}"

if [ ! -z "$@" ]; then
    PORTAL_TO_LOAD=$@
fi

echo "Loading portal '$PORTAL_TO_LOAD'..."

${SPLASH} prg 100
${SPLASH} clear_log
${SPLASH} log "StbApp is about to start..."

usleep 200000

# stop splash util gracefully
/etc/init.d/splashfb stop

# Switch OFF IR INPUT device and activate IR RAW READER
# Stbapp require only RAW READER enabled
echo 0 > /sys/devices/virtual/remote/amremote/use_input
echo 1 > /sys/devices/virtual/remote/amremote/use_reader

# setup Frame Buffer according to selected GRES
echo 1 > /sys/class/graphics/fb0/blank
echo 1 > /sys/class/graphics/fb1/blank
echo 1 > /sys/class/graphics/fb2/blank
echo 0 > /sys/class/graphics/fb2/blank
case $g_width in
    720)
	if [[ "$g_height" = "480" ]]; then
            fbset -fb /dev/fb0 -g 720 480 720 960 32
            fbset -fb /dev/fb1 -g 720 480 720 960 32
	else
            fbset -fb /dev/fb0 -g 720 576 720 1152 32
            fbset -fb /dev/fb1 -g 720 576 720 1152 32
	fi
    ;;
    1920)
	fbset -fb /dev/fb0 -g 1920 1080 1920 2160 32
	fbset -fb /dev/fb1 -g 1920 1080 1920 2160 32
    ;;
    *)
	fbset -fb /dev/fb0 -g 1280 720 1280 1440 32
	fbset -fb /dev/fb1 -g 1280 720 1280 1440 32
    ;;
esac


#display pan for double buffering
echo "0,$g_height" > /sys/class/graphics/fb0/pan

# make sure there will be no phantom images on the screen
echo 1 > /sys/class/graphics/fb0/osd_clear
echo 1 > /sys/class/graphics/fb1/osd_clear


echo 3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,498,469,443,420,381,349,322,299,279,262,246,233,221,210,201,192,184,\
177,170,164,158,153,148,143,139,135,131,128 \
> /sys/module/am_vecm/parameters/oo_y_lut_hdr_sdr_def


${BASEDIR}/stbapp -platform "eglfs" -plugin "EvdevKeyboard::repeat-delay=200:repeat-rate=30" -plugin "EvdevMouse:" $PORTAL_TO_LOAD
