#!/bin/sh

. /etc/utils/shell-utils.sh
DEBUG=0

BASEDIR=$(dirname "$0")

# WiFi interface name
IFACE_NAME=wlan0

case $1 in

    get_ip)
        ifconfig ${IFACE_NAME} 2>/dev/null | awk '/inet addr/{ printf substr($2, 6) }'
    ;;

    stop)
        log "Stopping driver (IPC call, PID $$)"

	# call using IPC cause we do NOT want to inherite all opened HISILICON handles
	# do NOT change this if you have no idea how to handle it other way
	ipc_invoke "$BASEDIR/wifi.sh p_stop"
    ;;

    p_stop)
        log "Stopping driver (PID $$)"

        /sbin/ifdown ${IFACE_NAME}

        log "Stopping driver DONE."
    ;;

    start)
        log "Start... (IPC call, PID $$)"

	# call using IPC cause we do NOT want to inherite all opened HISILICON handles
	# do NOT change this if you have no idea how to handle it other way
	ipc_invoke "$BASEDIR/wifi.sh p_start"
    ;;
    p_start)
        log "Start...(PID $$)"

        /sbin/ifdown ${IFACE_NAME}
        /sbin/ifup ${IFACE_NAME}

        log "Starting driver DONE."
    ;;

    restart)
        log "Restarting wifi... (IPC call, PID $$)"

	# call using IPC cause we do NOT want to inherite all opened HISILICON handles
	# do NOT change this if you have no idea how to handle it other way
	ipc_invoke "$BASEDIR/wifi.sh p_restart"
    ;;
    p_restart)
        log "Restarting wifi...(PID $$)"

        /sbin/ifdown ${IFACE_NAME}
        /sbin/ifup ${IFACE_NAME}

        log "Restarting DONE."
    ;;
    *)
        echo "Wireless init script v0.1"
        echo "usage: [start|stop|restart|get_ip]"
    ;;
esac

exit 0;


