#!/bin/sh

set -x

source /etc/utils/shell-utils.sh
DEBUG=0

TMP_DIR=/tmp/post_update_ext4_resize

fix_ext4() {
        ##### Remount partition
        #sync
        #mount -t ext4 $1 $TMP_DIR  >/dev/null 2>/dev/null
        #touch $TMP_DIR/usr/local/share
        #sleep 1
        #umount $TMP_DIR
        #sync
        #sleep 1

        ##### Resize partition
        e2fsck -f -y $1 >/dev/null 2>/dev/null
        if [ "$?" -ne "0" ]; then
            log "ERROR: FS check has failed for the '$1' device !"
            exit 1
        fi
	sync
        #sleep 1

	lenSectors=$( blockdev --getsz ${1} 2> /dev/null )
	if [ -z ${lenSectors} ]; then
            log "ERROR: get size has failed for the '%s' device !"
            exit 1
	fi

        #len=`cat /sys/class/block/$1/size 2>/dev/null`
        #len=$((len/2048))

        resize2fs $1 ${lenSectors}s
#  >/dev/null 2>/dev/null

        if [ "$?" -ne "0" ]; then
            log "ERROR: Resize has failed for the '$1' device !"
            exit 1
        fi
	sync
}

mkdir -p $TMP_DIR

fix_ext4 $1
exit 1

echo "OK"
