#!/bin/sh

#set -x

source /etc/utils/shell-utils.sh
DEBUG=0

TMP_DIR=/tmp/post_update_ext4_resize

fix_ext4() {
	lenSectors=$( blockdev --getsz ${1} 2>/dev/null )
	if [ -z ${lenSectors} ]; then
            log "ERROR: get size has failed for the '$1' device !"
            exit 1
	fi

        resize2fs -f $1 ${lenSectors}s >/dev/null 2>/dev/null

        if [ "$?" -ne "0" ]; then
            log "ERROR: Resize has failed for the '$1' device !"
            exit 1
        fi
	sync
}

mkdir -p $TMP_DIR

fix_ext4 $1

echo "OK"

exit 0
