#!/bin/sh

# This script will reboot device after long press (10 sec) to 'service' button
# Viktor Kovalov, INFOMIR LLC 2019-07

# service button
GIO="499"

# confgure GPIO
echo ${GIO} > /sys/class/gpio/export
echo in > /sys/class/gpio/gpio${GIO}/direction

i=0
while [ 1 ]; do
    sleep 1

    V=`cat /sys/class/gpio/gpio${GIO}/value`

    if [ "$V" -eq "0" ]; then
	i=$((i+1))

	# blink front LED once
	if [ -f "/sys/class/leds/mag-front-led/cnt" ]; then
	    echo "1" > /sys/class/leds/mag-front-led/cnt
	fi
    else 
	i=0
    fi

    if [ "$i" -eq "10" ]; then
	echo "[+] Executing 'RESET (software) for the device'"

	# blink front LED 100 times as an indication of reset
	if [ -f "/sys/class/leds/mag-front-led/cnt" ]; then
	    echo "100" > /sys/class/leds/mag-front-led/cnt
	fi

	reboot

	sleep 60
    fi

    #echo "V: $V, i: $i"
done

exit 0