#!/bin/sh

source /etc/utils/shell-utils.sh

temp_file=/ram/trustedcore.tmp
image_head=/ram/imgHead
target_file=/ram/target_file.img
cmp_file=/ram/cmp_file.img
mnt_path=/ram/tcore.mnt/

is_tee_type()
{
    imloadtee=`grep imloadtee -o /proc/cmdline`
    if [ "$imloadtee" == "imloadtee" ] ; then
        export $1=1
    else
        export $1=0
    fi
}

get_tee_mem_variant()
{
    mem=`cat /proc/cmdline`
    mem=${mem##*mem=}
    mem=${mem%% *}
    mem_size=`echo $mem | grep -Eo "[0-9]*"`
    mem_suffix=`echo $mem | grep -Eo "[GM]*"`
    if [ "$mem_suffix" == "G" ] ; then
        mem_size=$(($mem_size * 1024))
    fi
    if [ $mem_size -le 512 ] ; then
        export $1=512M
    elif [ $mem_size -lt 1024 ] ; then
        export $1=1G
    elif [ $mem_size -lt 2048 ] ; then
        export $1=2G
    fi
}

get_update_bank()
{
    bank=`/usr/local/share/app/bin/rdir.sh GetCurrentBank`
    if [ "$bank" == "RootFs" ] ; then
        export $1="2"
    else
        export $1=""
    fi
}

get_ubi_part_by_name()
{
    # $1[in] - partition name
    # $2[out] - device name
    num=`ubinfo /dev/ubi0 -N $1 2>/dev/null| grep -Eo "[0-9]*" | grep -m1 -E "[0-9]*"`
    if [ "$num" == "" ] ; then
        export $2=""
        return
    fi
    export $2=ubi0_$num
}

is_tee_type is_tee
if [ "$is_tee" != "1" ] ; then
    echo "Non TEE board. trustedcore write unsupported."
    exit 1;
fi

get_update_bank new_bank


if [ "$1" != "" ]; then
    temp_file=$1
fi

if [ ! -e $temp_file ]; then
    echo "ERROR: File $temp_file not present!!!"
    exit 1
fi

get_file_size "$temp_file" size

if [ $size -eq 0 ]; then
    echo "ERROR: Uploading bootloader is failed."
    exit 1;
fi

get_tee_mem_variant tee_mem

get_flash_type type

rm -f $image_head
dd if=$temp_file of=$image_head bs=1K count=1 2>/dev/null
offset=`awk '{if($0 == "Start data..."){s+=length($0)+1;print s;exit;}else{s+=length($0)+1;}}' $image_head` 2>/dev/null
dd if=/dev/null of=$image_head bs=1 count=0 seek=$offset 2>/dev/null

get_model_ext model_ext
get_hwver hwver
variant=$tee_mem

tmp=`grep -w "$variant" $image_head` 2>/dev/null
tc_len=`echo "$tmp" | awk '{print $2}'`
pos=`echo "$tmp" | awk '{print $3}'`
#echo "======[$variant] [$tc_len] [$pos] [$offset]======"
if [ "$pos" != "" ] && [ "$tc_len" != "" ]; then

    if [ $type == "nand" ]; then
        mkdir -p $mnt_path
        get_ubi_part_by_name "trustedcore"$new_bank name_part

        if [ "$name_part" == "" ] ; then
            echo "ERROR: trustedcore$new_bank not found"
            exit 1
        fi
        mount -t ubifs /dev/$name_part $mnt_path
        if [ $? -ne 0 ] ; then
            ubiupdatevol -t /dev/$name_part
            mount -t ubifs /dev/$name_part $mnt_path
            if [ $? -ne 0 ] ; then
                echo "ERROR: can't mount trustedcore$new_bank"
                exit 1
            fi
        fi
        rm $mnt_path/trustedcore.img 2>/dev/null >/dev/null
        dd if=$temp_file of=$mnt_path/trustedcore.img skip=$(($pos+$offset)) iflag=skip_bytes bs=$tc_len count=1 2>/dev/null
        if [ $? -ne 0 ] ; then
            umount /dev/$name_part
            echo "ERROR: Failed writing to trustedcore$new_bank"
            exit 1
        fi
        umount /dev/$name_part
        if [ $? -ne 0 ] ; then
            echo "ERROR: Failed umount trustedcore$new_bank"
            exit 1
        fi
        sync
        rm -rf $mnt_path
    elif [ $type == "mmc" ]; then
        get_name_and_len_part "trustedcore"$new_bank max name_part

        if [ "$name_part" == "" ] ; then
            echo "ERROR: trustedcore$new_bank not found"
            exit 1
        fi
        dd if=$temp_file of=/dev/$name_part skip=$(($pos+$offset)) iflag=skip_bytes bs=$tc_len count=1 2>/dev/null
    else
        echo "ERROR: Write to NAND flash failed!!!"
        exit 1
    fi
fi

rm -f $temp_file $image_head $target_file $cmp_file
echo "OK"
exit 0
