'use strict';

/* jshint unused:false */

var langTitles = {
		ru: 'RUS',
		uk: 'UKR',
		en: 'ENG',
		de: 'DEU',
		es: 'ESP',
		tr: 'TUR',
		el: 'GRE',
		ar: 'ARA'
	},
	board = {
		'ru': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: 'й', lSend: 'й', upper: 'Й', upSend: 'Й', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'ц', lSend: 'ц', upper: 'Ц', upSend: 'Ц', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'у', lSend: 'у', upper: 'У', upSend: 'У', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'к', lSend: 'к', upper: 'К', upSend: 'К', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'е', lSend: 'е', upper: 'Е', upSend: 'Е', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'н', lSend: 'н', upper: 'Н', upSend: 'Н', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'г', lSend: 'г', upper: 'Г', upSend: 'Г', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ш', lSend: 'ш', upper: 'Ш', upSend: 'Ш', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'щ', lSend: 'щ', upper: 'Щ', upSend: 'Щ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'з', lSend: 'з', upper: 'З', upSend: 'З', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'х', lSend: 'х', upper: 'Х', upSend: 'Х', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ъ', lSend: 'ъ', upper: 'Ъ', upSend: 'Ъ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['.', ',', '/', '\\'], lSend: ['.', ',', '/', '\\'], upper: ['.', ',', '/', '\\'], upSend: ['.', ',', '/', '\\'], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: 'ф', lSend: 'ф', upper: 'Ф', upSend: 'Ф', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ы', lSend: 'ы', upper: 'Ы', upSend: 'Ы', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'в', lSend: 'в', upper: 'В', upSend: 'В', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'а', lSend: 'а', upper: 'А', upSend: 'А', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'п', lSend: 'п', upper: 'П', upSend: 'П', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'р', lSend: 'р', upper: 'Р', upSend: 'Р', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'о', lSend: 'о', upper: 'О', upSend: 'О', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'л', lSend: 'л', upper: 'Л', upSend: 'Л', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'д', lSend: 'д', upper: 'Д', upSend: 'Д', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ж', lSend: 'ж', upper: 'Ж', upSend: 'Ж', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'э', lSend: 'э', upper: 'Э', upSend: 'Э', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: 'я', lSend: 'я', upper: 'Я', upSend: 'Я', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ч', lSend: 'ч', upper: 'Ч', upSend: 'Ч', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'с', lSend: 'с', upper: 'С', upSend: 'С', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'м', lSend: 'м', upper: 'М', upSend: 'М', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'и', lSend: 'и', upper: 'И', upSend: 'И', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'т', lSend: 'т', upper: 'Т', upSend: 'Т', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ь', lSend: 'ь', upper: 'Ь', upSend: 'Ь', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'б', lSend: 'б', upper: 'Б', upSend: 'Б', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ю', lSend: 'ю', upper: 'Ю', upSend: 'Ю', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['&amp;', '#', '$', '№'], lSend: ['&', '#', '$', '№'], upper: ['&amp;', '#', '$', '№'], upSend: ['&', '#', '$', '№'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['?', '!', '%', '^'], lSend: ['?', '!', '%', '^'], upper: ['?', '!', '%', '^'], upSend: ['?', '!', '%', '^'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: ['(', ')', '`', '~'], lSend: ['(', ')', '`', '~'], upper: ['(', ')', '`', '~'], upSend: ['(', ')', '`', '~'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'uk': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: 'й', lSend: 'й', upper: 'Й', upSend: 'Й', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'ц', lSend: 'ц', upper: 'Ц', upSend: 'Ц', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'у', lSend: 'у', upper: 'У', upSend: 'У', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'к', lSend: 'к', upper: 'К', upSend: 'К', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'е', lSend: 'е', upper: 'Е', upSend: 'Е', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'н', lSend: 'н', upper: 'Н', upSend: 'Н', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'г', lSend: 'г', upper: 'Г', upSend: 'Г', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ш', lSend: 'ш', upper: 'Ш', upSend: 'Ш', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'щ', lSend: 'щ', upper: 'Щ', upSend: 'Щ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'з', lSend: 'з', upper: 'З', upSend: 'З', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'х', lSend: 'х', upper: 'Х', upSend: 'Х', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ї', lSend: 'ї', upper: 'Ї', upSend: 'Ї', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['.', ',', '/', '\\'], lSend: ['.', ',', '/', '\\'], upper: ['.', ',', '/', '\\'], upSend: ['.', ',', '/', '\\'], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: 'ф', lSend: 'ф', upper: 'Ф', upSend: 'Ф', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'і', lSend: 'і', upper: 'І', upSend: 'І', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'в', lSend: 'в', upper: 'В', upSend: 'В', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'а', lSend: 'а', upper: 'А', upSend: 'А', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'п', lSend: 'п', upper: 'П', upSend: 'П', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'р', lSend: 'р', upper: 'Р', upSend: 'Р', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'о', lSend: 'о', upper: 'О', upSend: 'О', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'л', lSend: 'л', upper: 'Л', upSend: 'Л', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'д', lSend: 'д', upper: 'Д', upSend: 'Д', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ж', lSend: 'ж', upper: 'Ж', upSend: 'Ж', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'є', lSend: 'є', upper: 'Є', upSend: 'Є', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: 'я', lSend: 'я', upper: 'Я', upSend: 'Я', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ч', lSend: 'ч', upper: 'Ч', upSend: 'Ч', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'с', lSend: 'с', upper: 'С', upSend: 'С', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'м', lSend: 'м', upper: 'М', upSend: 'М', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'и', lSend: 'и', upper: 'И', upSend: 'И', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'т', lSend: 'т', upper: 'Т', upSend: 'Т', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ь', lSend: 'ь', upper: 'Ь', upSend: 'Ь', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'б', lSend: 'б', upper: 'Б', upSend: 'Б', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ю', lSend: 'ю', upper: 'Ю', upSend: 'Ю', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['&amp;', 'ґ', '$', '№'], lSend: ['&', 'ґ', '$', '№'], upper: ['&amp;', 'Ґ', '$', '№'], upSend: ['&', 'Ґ', '$', '№'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['?', '!', '%', '^'], lSend: ['?', '!', '%', '^'], upper: ['?', '!', '%', '^'], upSend: ['?', '!', '%', '^'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: ['(', ')', '`', '~'], lSend: ['(', ')', '`', '~'], upper: ['(', ')', '`', '~'], upSend: ['(', ')', '`', '~'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'en': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: '/', lSend: '/', upper: '/', upSend: '/', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'q', lSend: 'q', upper: 'Q', upSend: 'Q', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'w', lSend: 'w', upper: 'W', upSend: 'W', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'e', lSend: 'e', upper: 'E', upSend: 'E', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'r', lSend: 'r', upper: 'R', upSend: 'R', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 't', lSend: 't', upper: 'T', upSend: 'T', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'y', lSend: 'y', upper: 'Y', upSend: 'Y', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'u', lSend: 'u', upper: 'U', upSend: 'U', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'i', lSend: 'i', upper: 'I', upSend: 'I', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'o', lSend: 'o', upper: 'O', upSend: 'O', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'p', lSend: 'p', upper: 'P', upSend: 'P', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['.', ','], lSend: ['.', ','], upper: ['.',','], upSend: ['.',','], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: ['[', ']'], lSend: ['[', ']'], upper: ['[', ']'], upSend: ['[', ']'], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: '@', lSend: '@', upper: '@', upSend: '@', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'a', lSend: 'a', upper: 'A', upSend: 'A', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 's', lSend: 's', upper: 'S', upSend: 'S', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'd', lSend: 'd', upper: 'D', upSend: 'D', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'f', lSend: 'f', upper: 'F', upSend: 'F', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'g', lSend: 'g', upper: 'G', upSend: 'G', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'h', lSend: 'h', upper: 'H', upSend: 'H', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'j', lSend: 'j', upper: 'J', upSend: 'J', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'k', lSend: 'k', upper: 'K', upSend: 'K', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'l', lSend: 'l', upper: 'L', upSend: 'L', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['\\', '*', '&lt;', '&gt;'], lSend: ['\\', '*', '<', '>'], upper: ['\\', '*', '&lt;', '&gt;'], upSend: ['\\', '*', '<', '>'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: ['?', '!', '%', '^'], lSend: ['?', '!', '%', '^'], upper: ['?', '!', '%', '^'], upSend: ['?', '!', '%', '^'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'z', lSend: 'z', upper: 'Z', upSend: 'Z', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'x', lSend: 'x', upper: 'X', upSend: 'X', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'c', lSend: 'c', upper: 'C', upSend: 'C', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'v', lSend: 'v', upper: 'V', upSend: 'V', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'b', lSend: 'b', upper: 'B', upSend: 'B', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'n', lSend: 'n', upper: 'N', upSend: 'N', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'm', lSend: 'm', upper: 'M', upSend: 'M', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['&amp;', '#', '$', '№'], lSend: ['&', '#', '$', '№'], upper: ['&amp;', '#', '$', '№'], upSend: ['&', '#', '$', '№'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['`', '~'], lSend: ['`', '~'], upper: ['`', '~'], upSend: ['`', '~'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: ['(', ')', '{', '}'], lSend: ['(', ')', '{', '}'], upper: ['(', ')', '{', '}'], upSend: ['(', ')', '{', '}'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '.com', lSend: '.com', upper: '.com', upSend: '.com', type: 'sendtext', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'el': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: '/', lSend: '/', upper: '/', upSend: '/', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: ';', lSend: ';', upper: ':', upSend: ':', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ς', lSend: 'ς', upper: 'ς', upSend: 'ς', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ε', lSend: 'ε', upper: 'Ε', upSend: 'Ε', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ρ', lSend: 'ρ', upper: 'Ρ', upSend: 'Ρ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'τ', lSend: 'τ', upper: 'Τ', upSend: 'Τ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'υ', lSend: 'υ', upper: 'Υ', upSend: 'Υ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'θ', lSend: 'θ', upper: 'Θ', upSend: 'Θ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ι', lSend: 'ι', upper: 'I', upSend: 'Ι', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ο', lSend: 'ο', upper: 'Ο', upSend: 'O', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'π', lSend: 'π', upper: 'Π', upSend: 'Π', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['.', ','], lSend: ['.', ','], upper: ['.',','], upSend: ['.',','], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: ['[', ']'], lSend: ['[', ']'], upper: ['[', ']'], upSend: ['[', ']'], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: '@', lSend: '@', upper: '@', upSend: '@', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'α', lSend: 'α', upper: 'Α', upSend: 'Α', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'σ', lSend: 'σ', upper: 'Σ', upSend: 'Σ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'δ', lSend: 'δ', upper: 'Δ', upSend: 'Δ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'φ', lSend: 'φ', upper: 'Φ', upSend: 'Φ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'γ', lSend: 'γ', upper: 'Γ', upSend: 'Γ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'η', lSend: 'η', upper: 'Η', upSend: 'Η', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ξ', lSend: 'ξ', upper: 'Ξ', upSend: 'Ξ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'κ', lSend: 'κ', upper: 'Κ', upSend: 'Κ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'λ', lSend: 'λ', upper: 'Λ', upSend: 'Λ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['\\', '*', '&lt;', '&gt;'], lSend: ['\\', '*', '<', '>'], upper: ['\\', '*', '&lt;', '&gt;'], upSend: ['\\', '*', '<', '>'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: ['?', '!', '%', '^'], lSend: ['?', '!', '%', '^'], upper: ['?', '!', '%', '^'], upSend: ['?', '!', '%', '^'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'ζ', lSend: 'ζ', upper: 'Ζ', upSend: 'Ζ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'χ', lSend: 'χ', upper: 'Χ', upSend: 'Χ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ψ', lSend: 'ψ', upper: 'Ψ', upSend: 'Ψ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ω', lSend: 'ω', upper: 'Ω', upSend: 'Ω', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'β', lSend: 'β', upper: 'Β', upSend: 'Β', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ν', lSend: 'ν', upper: 'Ν', upSend: 'Ν', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'μ', lSend: 'μ', upper: 'Μ', upSend: 'Μ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['&amp;', '#', '$', '№'], lSend: ['&', '#', '$', '№'], upper: ['&amp;', '#', '$', '№'], upSend: ['&', '#', '$', '№'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['`', '~'], lSend: ['`', '~'], upper: ['`', '~'], upSend: ['`', '~'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: ['(', ')', '{', '}'], lSend: ['(', ')', '{', '}'], upper: ['(', ')', '{', '}'], upSend: ['(', ')', '{', '}'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '.com', lSend: '.com', upper: '.com', upSend: '.com', type: 'sendtext', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'es': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: '/', lSend: '/', upper: '/', upSend: '/', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'q', lSend: 'q', upper: 'Q', upSend: 'Q', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'w', lSend: 'w', upper: 'W', upSend: 'W', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'e', lSend: 'e', upper: 'E', upSend: 'E', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'r', lSend: 'r', upper: 'R', upSend: 'R', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 't', lSend: 't', upper: 'T', upSend: 'T', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'y', lSend: 'y', upper: 'Y', upSend: 'Y', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'u', lSend: 'u', upper: 'U', upSend: 'U', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'i', lSend: 'i', upper: 'I', upSend: 'I', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'o', lSend: 'o', upper: 'O', upSend: 'O', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'p', lSend: 'p', upper: 'P', upSend: 'P', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['\\', '*', '&lt;', '&gt;'], lSend: ['\\', '*', '<', '>'], upper: ['\\', '*', '&lt;', '&gt;'], upSend: ['\\', '*', '<', '>'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: ['.' ,','], lSend: ['.' ,','], upper: ['.' ,','], upSend: ['.' ,','], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: '@', lSend: '@', upper: '@', upSend: '@', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'a', lSend: 'a', upper: 'A', upSend: 'A', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 's', lSend: 's', upper: 'S', upSend: 'S', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'd', lSend: 'd', upper: 'D', upSend: 'D', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'f', lSend: 'f', upper: 'F', upSend: 'F', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'g', lSend: 'g', upper: 'G', upSend: 'G', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'h', lSend: 'h', upper: 'H', upSend: 'H', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'j', lSend: 'j', upper: 'J', upSend: 'J', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'k', lSend: 'k', upper: 'K', upSend: 'K', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'l', lSend: 'l', upper: 'L', upSend: 'L', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ñ', lSend: 'ñ', upper: 'Ñ', upSend: 'Ñ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: ['?', '!', '%', '^'], lSend: ['?', '!', '%', '^'], upper: ['?', '!', '%', '^'], upSend: ['?', '!', '%', '^'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'z', lSend: 'z', upper: 'Z', upSend: 'Z', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'x', lSend: 'x', upper: 'X', upSend: 'X', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'c', lSend: 'c', upper: 'C', upSend: 'C', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'v', lSend: 'v', upper: 'V', upSend: 'V', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'b', lSend: 'b', upper: 'B', upSend: 'B', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'n', lSend: 'n', upper: 'N', upSend: 'N', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'm', lSend: 'm', upper: 'M', upSend: 'M', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['&amp;', '#', '$', '№'], lSend: ['&', '#', '$', '№'], upper: ['&amp;', '#', '$', '№'], upSend: ['&', '#', '$', '№'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['`', '~'], lSend: ['`', '~'], upper: ['`', '~'], upSend: ['`', '~'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: ['(', ')', '{', '}'], lSend: ['(', ')', '{', '}'], upper: ['(', ')', '{', '}'], upSend: ['(', ')', '{', '}'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '.com', lSend: '.com', upper: '.com', upSend: '.com', type: 'sendtext', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'de': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: 'ß', lSend: 'ß', upper: '?', upSend: '?', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: '/', lSend: '/', upper: '/', upSend: '/', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'q', lSend: 'q', upper: 'Q', upSend: 'Q', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'w', lSend: 'w', upper: 'W', upSend: 'W', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'e', lSend: 'e', upper: 'E', upSend: 'E', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'r', lSend: 'r', upper: 'R', upSend: 'R', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 't', lSend: 't', upper: 'T', upSend: 'T', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'z', lSend: 'z', upper: 'Z', upSend: 'Z', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'u', lSend: 'u', upper: 'U', upSend: 'U', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'i', lSend: 'i', upper: 'I', upSend: 'I', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'o', lSend: 'o', upper: 'O', upSend: 'O', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'p', lSend: 'p', upper: 'P', upSend: 'P', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ü', lSend: 'ü', upper: 'Ü', upSend: 'Ü', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: '@', lSend: '@', upper: '@', upSend: '@', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'a', lSend: 'a', upper: 'A', upSend: 'A', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 's', lSend: 's', upper: 'S', upSend: 'S', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'd', lSend: 'd', upper: 'D', upSend: 'D', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'f', lSend: 'f', upper: 'F', upSend: 'F', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'g', lSend: 'g', upper: 'G', upSend: 'G', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'h', lSend: 'h', upper: 'H', upSend: 'H', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'j', lSend: 'j', upper: 'J', upSend: 'J', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'k', lSend: 'k', upper: 'K', upSend: 'K', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'l', lSend: 'l', upper: 'L', upSend: 'L', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['ö', 'ä'], lSend: ['ö', 'ä'], upper: ['Ö', 'Ä'], upSend: ['Ö', 'Ä'], type: 'spec', func: '', width: 1, 'class': ''},
//				{lower: ['\\', '*', '&lt;', '&gt;'], lSend: ['\\', '*', '<', '>'], upper: ['\\', '*', '&lt;', '&gt;'], upSend: ['\\', '*', '<', '>'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: ['&amp;', '#', '$', '€'], lSend: ['&', '#', '$', '€'], upper: ['&amp;', '#', '$', '€'], upSend: ['&', '#', '$', '€'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'y', lSend: 'y', upper: 'Y', upSend: 'Y', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'x', lSend: 'x', upper: 'X', upSend: 'X', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'c', lSend: 'c', upper: 'C', upSend: 'C', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'v', lSend: 'v', upper: 'V', upSend: 'V', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'b', lSend: 'b', upper: 'B', upSend: 'B', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'n', lSend: 'n', upper: 'N', upSend: 'N', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'm', lSend: 'm', upper: 'M', upSend: 'M', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: [',', '!', '%', '.'], lSend: [',', '!', '%', '.'], upper: [',', '!', '%', '.'], upSend: [',', '!', '%', '.'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['`', '~','/','\\'], lSend: ['`', '~','/','\\'], upper: ['`', '~','/','\\'], upSend: ['`', '~','/','\\'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: ['(', ')', '{', '}'], lSend: ['(', ')', '{', '}'], upper: ['(', ')', '{', '}'], upSend: ['(', ')', '{', '}'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '.com', lSend: '.com', upper: '.com', upSend: '.com', type: 'sendtext', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'tr': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['*', '+', '-', '_'], lSend: ['*', '+', '-', '_'], upper: ['*', '?', '-', '_'], upSend: ['*', '?', '-', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: '\'', lSend: '\'', upper: 'é', upSend: 'é', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'q', lSend: 'q', upper: 'Q', upSend: 'Q', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'w', lSend: 'w', upper: 'W', upSend: 'W', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'e', lSend: 'e', upper: 'E', upSend: 'E', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'r', lSend: 'r', upper: 'R', upSend: 'R', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 't', lSend: 't', upper: 'T', upSend: 'T', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'y', lSend: 'y', upper: 'Y', upSend: 'Y', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'u', lSend: 'u', upper: 'U', upSend: 'U', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ı', lSend: 'ı', upper: 'I', upSend: 'I', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'o', lSend: 'o', upper: 'O', upSend: 'O', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'p', lSend: 'p', upper: 'P', upSend: 'P', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ğ', lSend: 'ğ', upper: 'Ğ', upSend: 'Ğ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ü', lSend: 'ü', upper: 'Ü', upSend: 'Ü', type: 'send', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: 'a', lSend: 'a', upper: 'A', upSend: 'A', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 's', lSend: 's', upper: 'S', upSend: 'S', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'd', lSend: 'd', upper: 'D', upSend: 'D', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'f', lSend: 'f', upper: 'F', upSend: 'F', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'g', lSend: 'g', upper: 'G', upSend: 'G', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'h', lSend: 'h', upper: 'H', upSend: 'H', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'j', lSend: 'j', upper: 'J', upSend: 'J', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'k', lSend: 'k', upper: 'K', upSend: 'K', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'l', lSend: 'l', upper: 'L', upSend: 'L', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['ş','i'], lSend: ['ş','i'], upper: ['Ş','İ'], upSend: ['Ş','İ'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: ['\\', '*', '&lt;', '&gt;'], lSend: ['\\', '*', '<', '>'], upper: ['\\', '*', '&lt;', '&gt;'], upSend: ['\\', '*', '<', '>'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: ['?', '!', '%', '^'], lSend: ['?', '!', '%', '^'], upper: ['?', '!', '%', '^'], upSend: ['?', '!', '%', '^'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: [':', ';', '"', '"'], lSend: [':', ';', '"', '"'], upper: [':', ';', '"', '"'], upSend: [':', ';', '"', '"'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'z', lSend: 'z', upper: 'Z', upSend: 'Z', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'x', lSend: 'x', upper: 'X', upSend: 'X', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'c', lSend: 'c', upper: 'C', upSend: 'C', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'v', lSend: 'v', upper: 'V', upSend: 'V', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'b', lSend: 'b', upper: 'B', upSend: 'B', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'n', lSend: 'n', upper: 'N', upSend: 'N', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'm', lSend: 'm', upper: 'M', upSend: 'M', type: 'send', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['ö', 'ç', '.', ':'], lSend: ['ö', 'ç', '.', ':'], upper: ['Ö', 'Ç', '.', ':'], upSend: ['Ö', 'Ç', '.', ':'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: ['`', '~','@','?'], lSend: ['`', '~','@','?'], upper: ['`', '~','@','?'], upSend: ['`', '~','@','?'], type: 'spec', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: ['(', ')', '{', '}'], lSend: ['(', ')', '{', '}'], upper: ['(', ')', '{', '}'], upSend: ['(', ')', '{', '}'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '.com', lSend: '.com', upper: '.com', upSend: '.com', type: 'sendtext', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		],
		'ar': [
			[//1
				{lower: '1', lSend: '1', upper: '1', upSend: '1', type: 'send', func: '', width: 1, 'class': 'last_row corner_lt corner_lb'},
				{lower: '2', lSend: '2', upper: '2', upSend: '2', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '3', lSend: '3', upper: '3', upSend: '3', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '4', lSend: '4', upper: '4', upSend: '4', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '5', lSend: '5', upper: '5', upSend: '5', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '6', lSend: '6', upper: '6', upSend: '6', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '7', lSend: '7', upper: '7', upSend: '7', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '8', lSend: '8', upper: '8', upSend: '8', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '9', lSend: '9', upper: '9', upSend: '9', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: '0', lSend: '0', upper: '0', upSend: '0', type: 'send', func: '', width: 1, 'class': 'last_row'},
				{lower: ['-', '+', '=', '_'], lSend: ['-', '+', '=', '_'], upper: ['-', '+', '=', '_'], upSend: ['-', '+', '=', '_'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: 'Back <br /> space', lSend: 'Return', upper: 'Back <br /> space', upSend: 'Return', type: 'func', func: back, width: 2, 'class': 'last_row last_item corner_rt corner_rb double backspace accented'}
			],
			[//2
				{lower: 'ض', lSend: 'ض', upper: 'ض', upSend: 'ض', type: 'send', func: '', width: 1, 'class': 'corner_lt'},
				{lower: 'ص', lSend: 'ص', upper: 'ص', upSend: 'ص', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ث', lSend: 'ث', upper: 'ث', upSend: 'ث', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ق', lSend: 'ق', upper: 'ق', upSend: 'ق', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ف', lSend: 'ف', upper: 'ف', upSend: 'ف', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'غ', lSend: 'غ', upper: 'غ', upSend: 'غ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ع', lSend: 'ع', upper: 'ع', upSend: 'ع', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ه', lSend: 'ه', upper: 'ه', upSend: 'ه', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'خ', lSend: 'خ', upper: 'خ', upSend: 'خ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ح', lSend: 'ح', upper: 'ح', upSend: 'ح', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ج', lSend: 'ج', upper: 'ج', upSend: 'ج', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ة‎', lSend: 'ة‎', upper: 'ة‎', upSend: 'ة‎', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['.', '[',']', ','], lSend: ['.', '[',']', ','], upper: ['.', '[',']', ','], upSend: ['.', '[',']', ','], type: 'spec', func: '', width: 1, 'class': 'corner_rt last_item'}
			],
			[//3
				{lower: 'ش', lSend: 'ش', upper: 'ش', upSend: 'ش', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'س', lSend: 'س', upper: 'س', upSend: 'س', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['ء', 'ى', 'ئ', 'ي'], lSend: ['ء', 'ى', 'ئ', 'ي'], upper: ['ء', 'ى', 'ئ', 'ي'], upSend: ['ء', 'ى', 'ئ', 'ي'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'ب', lSend: 'ب', upper: 'ب', upSend: 'ب', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ل', lSend: 'ل', upper: 'ل', upSend: 'ل', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['آ', 'إ', 'ا', 'أ'], lSend: ['آ', 'إ', 'ا', 'أ'], upper: ['آ', 'إ', 'ا', 'أ'], upSend: ['آ', 'إ', 'ا', 'أ'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'ت', lSend: 'ت', upper: 'ت', upSend: 'ت', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ن', lSend: 'ن', upper: 'ن', upSend: 'ن', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'م', lSend: 'م', upper: 'م', upSend: 'م', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ك', lSend: 'ك', upper: 'ك', upSend: 'ك', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['\\', '*', '&lt;', '&gt;'], lSend: ['\\', '*', '<', '>'], upper: ['\\', '*', '&lt;', '&gt;'], upSend: ['\\', '*', '<', '>'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Enter', lSend: '', upper: 'Enter', upSend: '', type: 'func', func: enter, width: 2, 'class': 'accented double enter last_item'}
			],
			[//4
				{lower: ['?', '!', '%', '/'], lSend: ['?', '!', '%', '/'], upper: ['?', '!', '%', '/'], upSend: ['?', '!', '%', '/'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: [':', ';', '~', '"'], lSend: [':', ';', '~', '"'], upper: [':', ';', '~', '"'], upSend: [':', ';', '~', '"'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'ظ', lSend: 'ظ', upper: 'ظ', upSend: 'ظ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ط', lSend: 'ط', upper: 'ط', upSend: 'ط', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ذ', lSend: 'ذ', upper: 'ذ', upSend: 'ذ', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'د', lSend: 'د', upper: 'د', upSend: 'د', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ز', lSend: 'ز', upper: 'ز', upSend: 'ز', type: 'send', func: '', width: 1, 'class': ''},
				{lower: 'ر', lSend: 'ر', upper: 'ر', upSend: 'ر', type: 'send', func: '', width: 1, 'class': ''},
				{lower: ['ؤ', 'و'], lSend: ['ؤ', 'و'], upper: ['ؤ', 'و'], upSend: ['ؤ', 'و'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: '', lSend: 'up', upper: '', upSend: 'up', type: 'func', func: send_button, width: 1, 'class': 'arrow_up'},
				{lower: ['&amp;', '#', '$', '№'], lSend: ['&', '#', '$', '№'], upper: ['&amp;', '#', '$', '№'], upSend: ['&', '#', '$', '№'], type: 'spec', func: '', width: 1, 'class': ''},
				{lower: 'Shift', lSend: '', upper: 'Shift', upSend: '', type: 'func', func: shift, width: 2, 'class': 'accented double shift last_item'}
			],
			[//5
				{lower: '@', lSend: '@', upper: '@', upSend: '@', type: 'sendtext', func: '', width: 1, 'class': 'last_row corner_lb'},
				{lower: ['{', '}'], lSend: ['{', '}'], upper: ['{', '}'], upSend: ['{', '}'], type: 'spec', func: '', width: 1, 'class': 'last_row'},
				{lower: '.com', lSend: '.com', upper: '.com', upSend: '.com', type: 'sendtext', func: '', width: 1, 'class': 'last_row'},
				{lower: '', lSend: '', upper: '', upSend: '', type: 'func', func: langv_change, width: 2, 'class': 'last_row double lang accented'},
				{lower: 'Space', lSend: '', upper: 'Space', upSend: '', type: 'func', func: space, width: 3, 'class': 'last_row triple space accented'},
				{lower: '', lSend: 'left', upper: '', upSend: 'left', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_left'},
				{lower: '', lSend: 'down', upper: '', upSend: 'down', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_down'},
				{lower: '', lSend: 'right', upper: '', upSend: 'right', type: 'func', func: send_button, width: 1, 'class': 'last_row arrow_right'},
				{lower: 'Caps<br> Lock', lSend: '', upper: 'Caps<br> Lock', upSend: '', type: 'func', func: caps, width: 2, 'class': 'last_row last_item corner_rb double caps accented'}
			]
		]
	};
