#!/bin/sh

. /etc/utils/shell-utils.sh
DEBUG=0

WIFI_CURR_DRIVER_FILE=/ram/wifi/curr_driver

wifi_driver=$(cat "$WIFI_CURR_DRIVER_FILE" 2>/dev/null)

log "wifi_driver=$wifi_driver"
if [ -n "$wifi_driver" ]; then
    log "[i] External WIFI dongle active. Deiniting..."
    /etc/init.d/wifi_if_handler.sh stop
    exit 0
fi

log "Deinitializing embedded WIFI module."
/etc/init.d/wifi_stop_wa.sh
wpa_cli disconnect
wpa_cli flush
wpa_cli terminate
sleep 0.5
log "WPAsuplicant killed ."

ifconfig wlan1 down
ifconfig wlan-1 down

deinit_sdio_wifi()
{
    get_sdio_wifi MODULE
    case "${MODULE}" in
        sprd)
            rmmod sprdwl_ng
            #do not remove uwe5621_bsp_sdio since it can lead to crash during deep standby
            #rmmod uwe5621_bsp_sdio
        ;;
        rtk)
            rmmod 8822cs
        ;;
        rtk_8821)
            rmmod 8821cs
        ;;
    esac
}


case "$(lsusb)" in
  *0bda:d723*)
        log "Deinitializing [RTL8723DU]."
        rmmod 8723du
        ;;
  *0bda:b82c*)
        log "Deinitializing [RTL8822BU]."
        rmmod 8822bu
        ;;
  *)
        deinit_sdio_wifi
        ;;
esac


exit 0
