#!/bin/sh
##############################################################################
# If not stated otherwise in this file or this component's LICENSE file the
# following copyright and licenses apply:
#
# Copyright 2020 RDK Management
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
##############################################################################

. /etc/include.properties
. /etc/device.properties

if [ -f /etc/env_setup.sh ]; then
    . /etc/env_setup.sh
fi

PREV_LOG_PATH="$LOG_PATH/PreviousLogs"
PREV_LOG_BACKUP_PATH="$LOG_PATH/PreviousLogs_backup"

backupLog() {
    timestamp=`/bin/timestamp`
    echo "$timestamp $0: $*"
}

# create log workspace if not there
if [ ! -d "$LOG_PATH" ];then 
    rm -rf $LOG_PATH
    mkdir -p "$LOG_PATH"
fi

# create intermediate log workspace if not there
if [ ! -d $PREV_LOG_PATH ];then
    rm -rf $PREV_LOG_PATH
    mkdir -p $PREV_LOG_PATH
fi

# create log backup workspace if not there
if [ ! -d $PREV_LOG_BACKUP_PATH ];then
    rm  -rf $PREV_LOG_BACKUP_PATH
    mkdir -p $PREV_LOG_BACKUP_PATH
else
    rm  -rf $PREV_LOG_BACKUP_PATH/*
fi

if [ $APP_PERSISTENT_PATH ];then 
    PERSISTENT_PATH=$APP_PERSISTENT_PATH
else
    PERSISTENT_PATH=/opt/persistent
fi

touch $PERSISTENT_PATH/logFileBackup

# disk size check for recovery if /opt size > 90%
if [ -f /etc/os-release ] && [ -f /lib/rdk/disk_threshold_check.sh ];then
    sh /lib/rdk/disk_threshold_check.sh 0
fi

backupAndRecoverLogs()
{
    source=$1
    destn=$2
    operation=$3
    s_extn=$4
    d_extn=$5

    for file in $(find $source -mindepth 1 -maxdepth 1 -type f -name "$s_extn*");
    do
        $operation "$file" "$destn$d_extn${file/$source$s_extn/}"
    done
}

last_bootfile=`find $PREV_LOG_PATH -name last_reboot`
if [ -f "$last_bootfile" ];then
    rm -rf $last_bootfile
fi

sysLog="messages.txt"
sysLogBAK1="bak1_messages.txt"
sysLogBAK2="bak2_messages.txt"
sysLogBAK3="bak3_messages.txt"

if [ "$HDD_ENABLED" = "false" ]; then
    BAK1="bak1_"
    BAK2="bak2_"
    BAK3="bak3_"
    if [ ! `ls $PREV_LOG_PATH/$sysLog` ]; then
        if [ "$DEVICE_NAME" = "XiOne" ] && [ "$SOC" = "RTK" ]; then
            #For Xione Realtek SOC device
            find $LOG_PATH -maxdepth 1 -mindepth 1 \( -type l -o -type f \) \( -iname "*.txt*" -o -iname "*.log*" -o -iname "*.bin*" -o -name "bootlog" \) -exec mv '{}' $PREV_LOG_PATH \;
        else
            #For other media-client devices
	    find $LOG_PATH -maxdepth 1 -mindepth 1 \( -type l -o -type f \) \( -iname "*.txt*" -o -iname "*.log*" -o -name "bootlog" \) -exec mv '{}' $PREV_LOG_PATH \;
        fi
    elif [ ! `ls $PREV_LOG_PATH/$sysLogBAK1` ]; then
        # box reboot within 8 minutes after reboot
        backupAndRecoverLogs "$LOG_PATH/" "$PREV_LOG_PATH/" mv "" $BAK1
    elif [ ! `ls $PREV_LOG_PATH/$sysLogBAK2` ]; then
        # box reboot within 8 minutes after reboot
        backupAndRecoverLogs "$LOG_PATH/" "$PREV_LOG_PATH/" mv "" $BAK2
    elif [ ! `ls $PREV_LOG_PATH/$sysLogBAK3` ]; then
        # box reboot within 8 minutes after reboot
        backupAndRecoverLogs "$LOG_PATH/" "$PREV_LOG_PATH/" mv "" $BAK3
    else
        # box reboot within 8 minutes after reboot
        backupAndRecoverLogs "$PREV_LOG_PATH/" "$PREV_LOG_PATH/" mv "$BAK1" ""
        backupAndRecoverLogs "$PREV_LOG_PATH/" "$PREV_LOG_PATH/" mv "$BAK2" "$BAK1"
        backupAndRecoverLogs "$PREV_LOG_PATH/" "$PREV_LOG_PATH/" mv "$BAK3" "$BAK2"
        backupAndRecoverLogs "$LOG_PATH/" "$PREV_LOG_PATH/" mv "" "$BAK3"
    fi

    if [ -f /etc/os-release ];then
           /bin/touch $PREV_LOG_PATH/last_reboot
    else
           touch $PREV_LOG_PATH/last_reboot
    fi

    # logs cleanup after backup
    rm -rf $LOG_PATH/*.*
    find $LOG_PATH -name "*-*-*-*-*M-" -exec rm -rf {} \;
else
    if [ ! `ls $PREV_LOG_PATH/$sysLog` ]; then
       find $LOG_PATH -maxdepth 1 -mindepth 1 \( -type l -o -type f \) \( -iname "*.txt*" -o -iname "*.log*" -o -name "bootlog" \) -exec mv '{}' $PREV_LOG_PATH \;
       if [ -f /etc/os-release ];then
           /bin/touch $PREV_LOG_PATH/last_reboot
       else
           touch $PREV_LOG_PATH/last_reboot
       fi
    else
       find $PREV_LOG_PATH -name last_reboot | xargs rm >/dev/null
       timestamp=`date "+%m-%d-%y-%I-%M-%S%p"`
       LogFilePathPerm="$PREV_LOG_PATH/logbackup-$timestamp"
       mkdir -p $LogFilePathPerm
       find $LOG_PATH -maxdepth 1 -mindepth 1 \( -type l -o -type f \) \( -iname "*.txt*" -o -iname "*.log*" -o -name "bootlog" \)  -exec mv '{}' $LogFilePathPerm \;
       if [ -f /etc/os-release ];then
           /bin/touch "$LogFilePathPerm"/last_reboot 
       else
           touch $LogFilePathPerm/last_reboot
       fi
    fi
fi

if [ -f /tmp/disk_cleanup.log ];then
    mv /tmp/disk_cleanup.log $LOG_PATH
fi

if [ -f /tmp/mount_log.txt ];then
    mv /tmp/mount_log.txt $LOG_PATH
fi


cp /version.txt $LOG_PATH

if [ -f /etc/os-release ];then
    /bin/systemd-notify --ready --status="Logs Backup Done..!"
fi
