#!/bin/sh

# input argument validation
inputArg1=$1
inputArg2=$2
if [ $# -lt 2 ]; then
	echo "Usage: $0 <TYPE OF SCRIPT> </STOP-SERVICE/CLEAN-CONFIG>"
fi


erase_data()
{
#persistent data cleanup
if [ -d /opt/configs/rdkservices ]; then 
	rm -rf /opt/configs/rdkservices/*
       echo "Success: Deleted /opt/persistent/rdkservices/* contents"
else
	echo "Failed: Unable to delete /opt/persistent/rdkservices/* contents"
fi
if [ -d /data/persistent ]; then 
	rm -rf /data/persistent/*
       echo "Success: Deleted /data/persistent/* contents"
else
       echo "Failed: Unable to delete /data/persistent/* contents"
fi
	    
#Amazon data cleanup
if [ -d /opt/amazonPrime ]; then 
	rm -rf /opt/amazonPrime
       echo "Success: Deleted /opt/amazonPrime contents"
else
       echo "Failed: Unable to delete /opt/amazonPrime contents"
fi
		
#Html diagnostics cache cache
if [ "$inputArg1" != "COLDFACTORY" ]; then
	if [ -d /var/www/htmldiag ]; then
		rm -rf /var/www/htmldiag
       	echo "Success: Deleted /var/www/htmldiag contents"
	else
       	echo "Failed: Unable to delete /var/www/htmldiag contents"
	fi
	if [ "$inputArg1" == "WAREHOUSE" ]; then
		if [ -d /var/www/htmldiag2 ]; then
			rm -rf /var/www/htmldiag2
		        echo "Success: Deleted /var/www/htmldiag2 contents"
		else
       		echo "Failed: Unable to delete /var/www/htmldiag2 contents"
		fi
    	fi
fi
		
#Drm data cleanup
if [ "$inputArg1" != "COLDFACTORY" ]; then
	if [ -d /opt/WideVine ]; then
		rm -rf /opt/WideVine
	        echo "Success: Deleted /opt/WideVine contents"
	else
       	echo "Failed: Unable to delete /opt/WideVine contents"
	fi		
fi

#Hostfiles cleanup
if [ "$inputArg1" == "WAREHOUSE" ]; then
	if [ -f /tmp/hosts ]; then
		rm -rf /tmp/hosts
	        echo "Success: Deleted /tmp/hosts contents"
	else
       	echo "Failed: Unable to delete /tmp/hosts contents"
	fi
fi
		
#ds cleanup
if [ "$inputArg1" == "FACTORY" ]; then
	if [ -d /tmp/ds ]; then
		rm -rf /tmp/ds/*
	        echo "Success: Deleted /tmp/ds/* contents"
	else
       	echo "Failed: Unable to delete /tmp/ds/* contents"
	fi
fi
}

if [[ "$inputArg1" == "FACTORY" ]] || [[ "$inputArg1" == "WAREHOUSE" ]] || [[ "$inputArg1" = "COLDFACTORY" ]]; then
	if [ "$inputArg2" = "CLEAN-CONFIG" ];then
		erase_data
	else
		echo "Feature not defined for $0"
	fi	
fi
