#!/bin/sh

source /etc/utils/shell-utils.sh

cd /usr/local/share/app/

# read portal variables
get_fw_env "portal1" PORTAL_1
get_fw_env "portal2" PORTAL_2
get_fw_env "use_portal_dhcp" USE_PORTAL_DHCP

/etc/init.d/wifi_stop_wa.sh

SYSLOG_SRV=""
if [ -f "/ram/dhcp_ready" ]; then
    SYSLOG_SRV=`cat /ram/dhcp_ready | grep "syslog_srv="`
    SYSLOG_SRV=${SYSLOG_SRV%% *#*}
    SYSLOG_SRV=${SYSLOG_SRV#syslog_srv=}
fi

if [ "$SYSLOG_SRV" == "" ]; then
    get_fw_env "syslog_srv" SYSLOG_SRV
fi

PORTAL_TMP=`cat /ram/dhcp_ready | grep "portal_dhcp="`
PORTAL_TMP=${PORTAL_TMP%%#*}
#trim spaces
PORTAL_TMP=`echo $PORTAL_TMP`
PORTAL_TMP=${PORTAL_TMP#portal_dhcp=}

if [ "$USE_PORTAL_DHCP" == "true" ]; then
    get_fw_env "portal_dhcp" PORTAL_DHCP
    if [ "$PORTAL_DHCP" != "$PORTAL_TMP" ]; then
        set_fw_env "portal_dhcp" $PORTAL_TMP
    fi
fi

if [ "$SYSLOG_SRV" == "" ]; then
    ./run.sh > /dev/null 2>&1
else
    ./run.sh 2>&1 | logger -t stbapp
fi

sleep 1
