#!/bin/sh

# ARGS:
# $@ - portal to load

source /etc/utils/shell-utils.sh
source /etc/profile.d/property_set.sh
echo ppmgr amvideo > /sys/class/vdec/vdec_vfm_path
chmod a+rw /sys/class/tsync/event

. /usr/local/share/app/env.sh

# check for certain variables
/usr/local/share/app/bin/STD_check_env.sh

readonly PORTAL_TO_LOAD_DEFAULT="file:///usr/local/share/app/web/system/pages/loader/index.html"

if pgrep "ipcRDirService" > /dev/null
then
    echo "ipcRDirService is already running!"
else
    echo "ipcRDirService is not running, starting it!" 
    /usr/local/share/app/bin/ipcRDirService -d
fi

PORTAL_TO_LOAD=$PORTAL_TO_LOAD_DEFAULT

for X in `cat /proc/cmdline`
do
    if [[ ${X:0:10} == "bootmedia=" ]]; then
        [ "${CMD_LINE}" ] && CMD_LINE="${CMD_LINE}&${X}" || CMD_LINE="${CMD_LINE}${X}"
    elif [[ ${X:0:14} == "fallbackstate=" ]]; then
        [ "${CMD_LINE}" ] && CMD_LINE="${CMD_LINE}&${X}" || CMD_LINE="${CMD_LINE}${X}"
    elif [[ ${X:0:9} == "btnstate=" ]]; then
        [ "${CMD_LINE}" ] && CMD_LINE="${CMD_LINE}&${X}" || CMD_LINE="${CMD_LINE}${X}"
    fi
done
[ "${CMD_LINE}" ] && PORTAL_TO_LOAD="${PORTAL_TO_LOAD}?${CMD_LINE}"

if [ ! -z "$@" ]; then
    PORTAL_TO_LOAD=$@
fi

if [[ -z "${PORTAL_TO_LOAD}" ]]; then
    echo "[+] Portal URL NOT defined. Using default local portal"

    PORTAL_TO_LOAD=${PORTAL_TO_LOAD_DEFAULT}
fi

echo "Loading portal '$PORTAL_TO_LOAD'..."

usleep 200000

echo 3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,\
3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,498,469,443,420,381,349,322,299,279,262,246,233,221,210,201,192,184,\
177,170,164,158,153,148,143,139,135,131,128 \
> /sys/module/am_vecm/parameters/oo_y_lut_hdr_sdr_def

export QT_WAYLAND_DISABLE_KEYBOARD=1
cd /usr/local/share/app && ./stbapp -plugin "EvdevKeyboard::repeat-delay=200:repeat-rate=30" -plugin "EvdevMouse:" ${PORTAL_TO_LOAD}
